/* Thurlby-Thandar TSXP series power supplies instrument driver include */

/*== GLOBAL CONSTANT DECLARATIONS =========================================*/

/* Replace 10 with the maximum number of devices of this type being used.  */
#define tsxp_MAX_INSTR        10

/*== GLOBAL FUNCTION DECLARATIONS =========================================*/
int tsxp_init (int addr,int *instrID);
int tsxp_set_op(int instrID,double voltage,double current);
void tsxp_set_ovp(int instrID, double ovp);
void tsxp_set_damping (int instrID, int dmpg);
int tsxp_op_switch (int instrID, int op_stat);
int tsxp_set_status (int instrID, int reg_type,int byte_value);
void tsxp_read_volts (int instrID,double *voltage);
void tsxp_read_current(int instrID,double  *current);
int tsxp_read_status (int instrID, int reg_type, int *byte);
int tsxp_store (int instrID, int store_no);
int tsxp_recall (int instrID, int store_no);
int tsxp_send_cmd (int instrID, char *cmd_buf);
int tsxp_get_response (int instrID,char *cmd_buf, int *bcount);
int tsxp_send_from_file (int instrID, char *fname);
int tsxp_get_to_file (int instrID,char *fname);
int tsxp_close (int instrID);
